
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Jul 22 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version KMNG_ATP_TST_ManageOp.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_Mem.h"
#include "CRYS.h"
#include "CRYS_KMNG.h"
#include "CRYS_AES.h"
#include "CRYS_DES.h"
#include "CRYS_error.h"
#include "CRYS_HASH.h"
#include "CRYS_HMAC.h"
#include "CRYS_RSA_Types.h"
#include "KMNG_Defs.h"
#include "KMNG_API.h"
#include "KMNG_Ext_ATP_TST_Defines.h"
#include "KMNG_TST_Utils.h"
#include "KMNG_Ext_ATP_KeysOp.h"



/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

//DxUint32_t TST_KeyOperations_Buf[KMNG_TST_MAX_SIZE_KEY_RING_BUF];
//KMNG_AES_WrappedKey_t   TST_AESWrappedKey;
//KMNG_DES_WrappedKey_t   TST_DESWrappedKey;
//KMNG_HMAC_WrappedKey_t  TST_HMACWrappedKey;
//KMNG_RSA_WrappedKey_t   TST_RSAWrappedKey;
//KMNG_DH_WrappedKey_t	  TST_DHWrappedKey;

//extern DxUint32_t TST_KeyRing_Buf[KMNG_TST_MAX_SIZE_KEY_RING_BUF];

//extern const DxUint32_t TST_NumOf_SymKeysOpTests;
//extern const DxUint32_t TST_NumOf_RSAKeysOpTests;
//extern const DxUint32_t TST_NumOf_DHKeysTests;

extern TST_Ext_KeysSym_TestDataStruct SEP_AES_KeysOpSym_TestData[];
extern TST_Ext_KeysSym_TestDataStruct SEP_DES_KeysOpSym_TestData[];
extern TST_Ext_KeysSym_TestDataStruct SEP_HMAC_KeysOpSym_TestData[];
//extern TST_KeysSym_TestDataStruct TST_KeysOpSym_TestData[];
//extern TST_KeysRSA_TestDataStruct TST_KeysOpRSA_TestData[];
//extern TST_KeysRSAHASHData_TestDataStruct TST_KeysOpRSAHASHData_TestData[];
//extern TST_KeysDHData_TestDataStruct TST_KeysDHData_TestData[];

//extern CRYS_DHUserPubKey_t TST_DHUserPubKey;
//extern CRYS_DHPrimeData_t  TST_DHPrimeData;
//TST_KeyDHServerData_Struct TST_KeyDHServerData;

/************* Private function prototype ***********************/
/*DxError_t KMNG_TST_Key_Ring_Initialization(DxUint32_t NumOfSymKeys, DxUint32_t NumOfRSAKeys, 
                                           DxUint32_t NumOfDHKeys, DxUint8_t* KeyRingPwd, 
                                           DxUint32_t PwdLen, DxUint8_t* KeyRing_ptr, 
                                           DxUint32_t KeyRingBufferSize);*/
/************************ Public Functions ******************************/

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_KeysOperation      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an acceptance test for Key management API's. The function 
 *  tests the operations on keys.
 *  
 * Algorithm:       
 * 1. Initialize a keys ring
 * 2. Create and import symmetric and RSA keys
 * 3. Activate and use each of the keys
 * 4. Export and verify each of the keys
 * 
 *  * Implements KMNG ATP section 5.2 
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_Ext_AES_ImportExportSymKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t            TST_index = 0;    
    DxError_t             TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_Ext_ImportExportSymKeys";     
                              
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_Ext_ImportExportSymKeys Test ************** \n"));      
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    
    TST_TestStatus = DX_SUCCESS;

	/* calling the AES ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = SEPQA_KMNG_ImportExportSymKeys(
		&SEP_AES_KeysOpSym_TestData[0]
		);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"SEPQA_KMNG_AES_ImportExportSymKeys","SEPQA_KMNG_AES_ImportExportSymKeys",TST_MasterTestName);                   

#if CRYS_ATP_TST_EXIT_ON_ERROR
	if (TST_TestStatus != DX_SUCCESS) 
		return TESTFAIL;
#endif  	
        
    
}

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_KeysOperation      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an acceptance test for Key management API's. The function 
 *  tests the operations on keys.
 *  
 * Algorithm:       
 * 1. Initialize a keys ring
 * 2. Create and import symmetric and RSA keys
 * 3. Activate and use each of the keys
 * 4. Export and verify each of the keys
 * 
 *  * Implements KMNG ATP section 5.2 
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_Ext_DES_ImportExportSymKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t            TST_index = 0;    
    DxError_t             TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_Ext_DES_ImportExportSymKeys";     
                              
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_Ext_DES_ImportExportSymKeys Test ************** \n"));      
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    
    TST_TestStatus = DX_SUCCESS;

	/* calling the AES ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = SEPQA_KMNG_ImportExportSymKeys(
		&SEP_DES_KeysOpSym_TestData[0]
		);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"SEPQA_KMNG_ImportExportSymKeys","KMNG_ExtApp_ATP_Ext_DES_ImportExportSymKeys",TST_MasterTestName);                   

#if CRYS_ATP_TST_EXIT_ON_ERROR
	if (TST_TestStatus != DX_SUCCESS) 
		return TESTFAIL;
#endif  	
        
    
}

/*****************************************************************************
 * Function Name:                                                           
 *  KMNG_ATP_TST_KeysOperation      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an acceptance test for Key management API's. The function 
 *  tests the operations on keys.
 *  
 * Algorithm:       
 * 1. Initialize a keys ring
 * 2. Create and import symmetric and RSA keys
 * 3. Activate and use each of the keys
 * 4. Export and verify each of the keys
 * 
 *  * Implements KMNG ATP section 5.2 
 *
 ******************************************************************************/                                
DxError_t KMNG_ExtApp_ATP_Ext_HMAC_ImportExportSymKeys( void ) 
{

    /********* TST Variables Definitions ************/
    DxUint32_t            TST_index = 0;    
    DxError_t             TST_Status = DX_SUCCESS, TST_TestStatus = DX_SUCCESS;        
    DxChar                TST_MasterTestName[TST_FUNC_STRING_LEN] = "KMNG_ExtApp_ATP_Ext_HMAC_ImportExportSymKeys";     
                              
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n"));
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"************** KMNG_ExtApp_ATP_Ext_HMAC_ImportExportSymKeys Test ************** \n"));      
    KMNG_LOG_TST_PRINT((KMNG_ATP_TST_MSG,"********************************************************************* \n \n"));
    
    TST_TestStatus = DX_SUCCESS;

	/* calling the AES ATP SEP function */ 
	/*----------------------------------*/
	TST_TestStatus = SEPQA_KMNG_ImportExportSymKeys(
		&SEP_HMAC_KeysOpSym_TestData[0]
		);

	TST_TestStatus = TST_ATP_CheckErrorReturn(TST_TestStatus,"SEPQA_KMNG_ImportExportSymKeys","KMNG_ExtApp_ATP_Ext_HMAC_ImportExportSymKeys",TST_MasterTestName);                   

#if CRYS_ATP_TST_EXIT_ON_ERROR
	if (TST_TestStatus != DX_SUCCESS) 
		return TESTFAIL;
#endif  	
        
    
}

/***************************************************************************************************************************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************************************************/
/***--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************************************************/
/***************************************************************************************************************************************************************/


